import symhelpers

def hasSamePitches(x,y):
    return symhelpers.mod12Same([i[0] for i in x], [i[0] for i in y])

def hasSamePitchesPrefix(x,y):
    if len(x) < 3:
        if len(y) < 3:
            return True
        return False
    return symhelpers.mod12Same([i[0] for i in x[:3]], [i[0] for i in y[:3]])

def hasAddOnePitchSymmetry(x,y):
    if abs(len(x) - len(y)) != 1:
        return False
    return any([[q[0] for q in x[:i]] + [q[0] for q in x[i+1:]] == y for i in range(len(x))]) or any([[q[0] for q in y[:i]] + [q[0] for q in y[i+1:]] == x for i in range(len(y))])

def hasSamePitchesSuffix(x,y):
    if len(x) < 3:
        if len(y) < 3:
            return True
        return False
    return symhelpers.mod12Same([i[0] for i in x[-3:]], [i[0] for i in y[-3:]])

def hasIntervalSymmetry(x,y):
    if len(x) != len(y):
        return False
    ints_x = [x[i][0] - x[i - 1][0] for i in range(1, len(x))]
    ints_y = [y[i][0] - y[i - 1][0] for i in range(1, len(y))]
    return len(ints_x) < 3 or len([abs(ints_x[k] - ints_y[k]) <= 2 for k in range(len(ints_x))]) >= len(ints_x) - 2

def hasIntervalPrefix(x,y):
    if len(x) < 4 and len(y) < 4:
        return True
    if len(x) < 4 or len(y) < 4:
        return False
    ints_x = [x[i][0] - x[i - 1][0] for i in range(1, len(x))]
    ints_y = [y[i][0] - y[i - 1][0] for i in range(1, len(y))]
    return len(ints_x) < 3 or len(ints_y) < 3 or all([abs(ints_x[k] - ints_y[k]) <= 2 for k in range(3)])

def hasIntervalSuffix(x,y):
    if len(x) < 4:
        if len(y) < 4:
            return True
        return False
    ints_y = [y[i][0] - y[i - 1][0] for i in range(1, len(y))]
    ints_x = [x[i][0] - x[i - 1][0] for i in range(1, len(x))]
    return len(ints_x) < 3 or len(ints_y) >= 3 and all([abs(ints_x[-k] - ints_y[-k]) <= 2 for k in range(1,4)])

def hasChangeOnePitchSymmetry(x,y):
    if len(x) != len(y):
        return False
    return hasSamePitches(x,y) or any([symhelpers.mod12Same([q[0] for q in x[:i]] + [q[0] for q in x[i+1:]], [q[0] for q in y[:i]] + [q[0] for q in y[i+1:]]) for i in range(len(x))])

def hasNonTrivialPrefix(x,y):
    if [i[1] for i in x[:3]] == [i[1] for i in y[:3]] and  symhelpers.mod12Same([i[0] for i in x[:3]], [i[0] for i in y[:3]]):
        return True
    return False

def hasNonTrivialSuffix(x,y):
    if [i[1] for i in x[-3:]] == [i[1] for i in y[-3:]] and  symhelpers.mod12Same([i[0] for i in x[-3:]], [i[0] for i in y[-3:]]):
        return True
    return False

def hasSameRhythm(x,y):
    return [q[1] for q in x] == [q[1] for q in y]

def hasAddOneRhythmSymmetry(x,y):
    if abs(len(x) - len(y)) > 1:
        return False
    onsets_x = [sum([q[1] for q in x[:i]]) for i in range(len(x))]
    onsets_y = [sum([q[1] for q in y[:i]]) for i in range(len(y))]
    return hasSameRhythm(x,y) or any([onsets_x == onsets_y[:i] + onsets_y[i + 1:] for i in range(len(y))]) or any([onsets_y == onsets_x[:i] + onsets_x[i + 1:] for i in range(len(x))])

def hasSubsetRhythm(x,y):
    onsets_x = [sum([q[1] for q in x[:i]]) for i in range(len(x))]
    onsets_y = [sum([q[1] for q in y[:i]]) for i in range(len(y))]
    return all([x in onsets_y for x in onsets_x]) or all([y in onsets_x for y in onsets_y])

def hasSameContour(x,y):
    if symhelpers.veryDifferentLengths(x,y):
        return False
    cont_x_pit = [len(set([k for k in [q[0] for q in x] if k < x[i][0]])) for i in range(len(x))]
    cont_x_dur = [len(set([k for k in [q[1] for q in x] if k < x[i][1]]))  for i in range(len(x))]
    cont_y_pit = [len(set([k for k in [q[0] for q in y] if k < y[i][0]]))  for i in range(len(y))]
    cont_y_dur = [len(set([k for k in [q[1] for q in y] if k < y[i][1]]))  for i in range(len(y))]
    return (cont_x_pit == cont_y_pit) and (cont_x_dur == cont_y_dur)

def hasSameContourPrefix(x,y):
    if len(x) < 3 and len(y) < 3:
        return True
    if len(x) < 3 or len(y) < 3:
        return False
    if symhelpers.veryDifferentLengths(x,y):
        return False
    cont_x_pit = [len(set([k for k in [q[0] for q in x] if k < x[i][0]])) for i in range(3)]
    cont_x_dur = [len(set([k for k in [q[1] for q in x] if k < x[i][1]]))  for i in range(3)]
    cont_y_pit = [len(set([k for k in [q[0] for q in y] if k < y[i][0]]))  for i in range(3)]
    cont_y_dur = [len(set([k for k in [q[1] for q in y] if k < y[i][1]]))  for i in range(3)]
    return (cont_x_pit[:3] == cont_y_pit[:3]) and (cont_x_dur[:3] == cont_y_dur[:3])

def hasSameContourSuffix(x,y):
    if len(x) < 3 and len(y) < 3:
        return True
    if len(x) < 3 or len(y) < 3:
        return False
    if symhelpers.veryDifferentLengths(x,y):
        return False
    cont_x_pit = [len(set([k for k in [q[0] for q in x] if k < x[i][0]])) for i in range(len(x) - 3, len(x))]
    cont_x_dur = [len(set([k for k in [q[1] for q in x] if k < x[i][1]]))  for i in range(len(x) - 3, len(x))]
    cont_y_pit = [len(set([k for k in [q[0] for q in y] if k < y[i][0]]))  for i in range(len(y) - 3, len(y))]
    cont_y_dur = [len(set([k for k in [q[1] for q in y] if k < y[i][1]]))  for i in range(len(y) - 3, len(y))]
    return (cont_x_pit[-3:] == cont_y_pit[-3:]) and (cont_x_dur[-3:] == cont_y_dur[-3:])

def hasLongFirstNote(x,y):
    return x[0][1] >= 2 and y[0][1] >= 2
    
def hasLongLastNote(x,y):
    return x[-1][1] >= 2 and y[-1][1] >= 2

def hasSameRhythmSequence(x, y):
    if hasSameRhythm(x, y):
        return True
    if len(x) < 4 or len(y) < 4:
        return False
    x_rhythms = [n[1] for n in x]
    y_rhythms = [n[1] for n in y]
    x_first_half = x[:(len(x) // 2)]
    x_second_half = x[(len(x) // 2):]
    y_first_half = y[:(len(y) // 2)]
    y_second_half = y[(len(y) // 2):]
    x_fh_rhythms = [n[1] for n in x_first_half]
    x_sh_rhythms = [n[1] for n in x_second_half]
    y_fh_rhythms = [n[1] for n in y_first_half]
    y_sh_rhythms = [n[1] for n in y_second_half]
    if (len(x_fh_rhythms) > 2 and symhelpers.listSequenceIn(x_fh_rhythms, y_rhythms)) or (len(x_sh_rhythms) > 2 and symhelpers.listSequenceIn(x_sh_rhythms, y_rhythms)):
        return True
    if (len(y_fh_rhythms) > 2 and symhelpers.listSequenceIn(y_fh_rhythms, x_rhythms)) or (len(y_sh_rhythms) > 2 and symhelpers.listSequenceIn(y_sh_rhythms, x_rhythms)):
        return True
    return False
    
def hasNoLeapsAndWithinOctave(x, y):
    ints_x = [x[i][0] - x[i - 1][0] for i in range(1, len(x))]
    ints_y = [y[i][0] - y[i - 1][0] for i in range(1, len(y))]
    if any([i > 5 for i in ints_x]) or any([i > 5 for i in ints_y]): # No leaps
        return False
    x_pitches = [i[0] for i in x]
    y_pitches = [i[0] for i in y]
    if (max(x_pitches) - min(x_pitches)) >= 12 or (max(y_pitches) - min(y_pitches)) >= 12: # Single measure spans octave
        return True
    all_pitches = x_pitches + y_pitches
    return (max(all_pitches) - min(all_pitches)) < 12 # All notes within less than a full octave

def hasAllInDiatonicScale(x, y):
    all_notes = set([i[0] % 12 for i in x] + [i[0] % 12 for i in y])
    maj_scale = [0, 2, 4, 5, 7, 9, 11]
    for k in range(12):
        if all_notes <= set([(n + k) % 12 for n in maj_scale]):
            return True
    return False

def hasSyncopationOrNoSyncopation(x, y):
    if len(x) < 2 or len(y) < 2:
        return False
    onsets_x = [sum([q[1] for q in x[:i]]) for i in range(len(x))]
    onsets_y = [sum([q[1] for q in y[:i]]) for i in range(len(y))]
    x_has_sync = any([(int(onsets_x[i]) != int(onsets_x[i - 1]) and onsets_x[i] % 1 != 0 and onsets_x[i - 1] % 1 != 0) for i in range(1, len(onsets_x))])
    y_has_sync = any([(int(onsets_y[i]) != int(onsets_y[i - 1]) and onsets_y[i] % 1 != 0 and onsets_y[i - 1] % 1 != 0) for i in range(1, len(onsets_y))])
    return x_has_sync == y_has_sync

def hasConsecutiveShortNotes(x, y):
    x_durs = [n[1] for n in x]
    y_durs = [n[1] for n in y]
    return (any([(x_durs[i] < 1 and x_durs[i - 1] < 1) for i in range(1, len(x_durs))]) and any([(y_durs[i] < 1 and y_durs[i - 1] < 1) for i in range(1, len(y_durs))]))